	function H = LATTICE_HB_H(first, second, d, points)
 
	% 	Calculates the magnitude response for a half-band 
	%	linear-phase lattice WDF
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB

	%	Author: 			Hakan Johansson 2004-04-02
	%	Modfied by:			LW 2015-05-21
	% 	Copyright:			by authors - not released for commercial use
	%	Version: 			1
	%	Known bugs:			
	% 	Report bugs to:		lars.wanhammar@liu.se
	
	if (first==1)
		delays = 2*length(second)-d;
	elseif (second == 1)
		delays = 2*length(first)-d;
	else
		delays = 2*(length(first)+length(second))-d;
	end
	N0 = 1;
	D0 = 1;
	N1 = [zeros(size(1:delays)) 1];
	D1 = [1 zeros(size(1:delays))];
	
	if ~(first == 1)
		for c = 1:length(first),
			N0 = conv(N0,[-first(c) 0 1]);
			D0 = conv(D0,[1 0 -first(c)]);
		end
	end
	if ~(second == 1)
		for c = 1:2:length(second),
			N0 = conv(N0,[-second(c) 0 -second(c+1)*(1-second(c)) 0 1]);
			D0 = conv(D0,[1 0 -second(c+1)*(1-second(c)) 0 -second(c)]);
		end
	end

	[H0, WTm] = freqz(N0,D0,points*360,'whole');
	[H1, WTm] = freqz(N1,D1,points*360,'whole');
	H = H0 + H1;
	
	%HN = conv(N0,D1)+conv(N1,D0);
	%HD = conv(D0,D1);
	%[H,WTm] = freqz(HN,HD,points*360,'whole');
	H = abs(H)/2;
